<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Fragmentador Universal M3U</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.0/jszip.min.js"></script>

<style>
*{box-sizing:border-box;margin:0;padding:0;font-family:Segoe UI,Arial}
body{background:#0b1020;color:#fff;min-height:100vh;padding-bottom:140px}
header{background:linear-gradient(135deg,#6366f1,#8b5cf6);padding:25px;text-align:center;font-size:28px;font-weight:700}
.container{max-width:1400px;margin:auto;padding:20px}
.input-box{background:#121836;padding:20px;border-radius:12px;margin-bottom:20px}
.input-box input,.input-box textarea{width:100%;padding:12px;margin-top:10px;border-radius:8px;border:none;font-size:15px}
textarea{min-height:140px}
button{border:none;padding:12px 20px;border-radius:10px;font-size:16px;cursor:pointer}
.btn-primary{background:#6366f1;color:#fff}
.btn-danger{background:#ef4444;color:#fff}
.btn-success{background:#22c55e;color:#fff}
.btn-info{background:#0ea5e9;color:#fff}
.btn-warning{background:#facc15;color:#000}

.top-menu{position:sticky;top:0;background:#0b1020;padding:15px;display:flex;gap:12px;z-index:100;overflow-x:auto}
.top-menu button{flex:1;background:#1e293b;color:#fff}
.top-menu button.active{background:#6366f1}

.category-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(350px,1fr));gap:20px;margin-top:20px}
.category-card{background:linear-gradient(135deg,#1e293b,#020617);border-radius:15px;padding:20px;position:relative;cursor:pointer}
.category-title{font-size:22px;font-weight:700}
.category-count{opacity:.7;margin-top:5px}
.card-buttons{margin-top:15px;display:flex;gap:10px}
.card-buttons button{flex:1}
.checkbox{position:absolute;top:15px;right:15px;transform:scale(1.3)}

#loader{display:none;position:fixed;inset:0;background:rgba(0,0,0,.9);z-index:9999;flex-direction:column;align-items:center;justify-content:center}
#loaderRing{width:140px;height:140px;border-radius:50%;border:12px solid #6366f1;border-top:12px solid transparent;animation:spin 1s linear infinite;margin-bottom:20px}
@keyframes spin{to{transform:rotate(360deg)}}
#loaderText{font-size:26px;margin-bottom:10px}
#loaderCounts{font-size:18px;color:#a5b4fc}
#loaderPercent{font-size:28px;margin-top:10px}

.float-bar{position:fixed;bottom:0;left:0;right:0;background:#020617;padding:15px;display:flex;gap:10px;align-items:center}
.float-bar button{flex:1}
</style>
</head>

<body>

<header>📡 Fragmentador Universal M3U</header>

<div class="container">

<div class="input-box">
  <input id="m3uUrl" placeholder="Cole o link M3U" onblur="checarValidade()">
  <div style="margin-top:8px;font-size:18px;color:#a5b4fc">
    ⏳ Validade: <b id="validadeM3U">—</b>
  </div>

  <textarea id="m3uText" placeholder="Ou cole a playlist"></textarea>
  <input type="file" id="m3uFile" accept=".m3u,.m3u8,.txt">

  <div style="margin-top:15px;display:flex;gap:10px">
    <button class="btn-primary" onclick="processar()">⚡ Processar Lista</button>
    <button class="btn-danger" onclick="limpar()">🧹 Limpar</button>
  </div>
</div>

<div class="top-menu">
  <button onclick="filtrar('all',this)" class="active">⭐ Todos</button>
  <button onclick="filtrar('canal',this)">📺 Canais</button>
  <button onclick="filtrar('filme',this)">🎬 Filmes</button>
  <button onclick="filtrar('serie',this)">📺 Séries</button>
  <button onclick="filtrar('sem',this)">❓ Sem Cat</button>
  <button onclick="marcarTodos()">☑ Marcar</button>
  <button onclick="desmarcarTodos()">❌ Desmarcar</button>
</div>

<div id="grid" class="category-grid"></div>

</div>

<div class="float-bar">
  <div style="flex:1;font-size:18px;color:#a5b4fc">
    📌 Selecionados: <b id="selCount">0</b>
  </div>
  <button class="btn-success" onclick="baixarZip()">📦 Baixar ZIP</button>
  <button class="btn-info" onclick="baixarSelecionados()">⬇️ Baixar Selecionados</button>
</div>

<div id="loader">
  <div id="loaderText">Processando canais...</div>
  <div id="loaderRing"></div>
  <div id="loaderCounts">0 canais</div>
  <div id="loaderPercent">0%</div>
</div>

<script>
let categorias={canal:{},filme:{},serie:{},sem:{}};
let filtroAtual="all";

function showLoader(){loader.style.display="flex";}
function hideLoader(){loader.style.display="none";}

function atualizarSelecionados(){
 selCount.innerText=document.querySelectorAll(".checkbox:checked").length;
}

async function checarValidade(){
 const url=m3uUrl.value.trim();
 if(!url)return;
 validadeM3U.innerText="Verificando...";
 try{
  const r=await fetch("Check/api_validade.php?url="+encodeURIComponent(url));
  const j=await r.json();
  validadeM3U.innerText=j.validade||"Indisponível";
 }catch(e){validadeM3U.innerText="Erro";}
}

async function processar(){
 showLoader();
 categorias={canal:{},filme:{},serie:{},sem:{}};

 let texto="";
 if(m3uUrl.value) texto=await (await fetch("proxy.php?url="+encodeURIComponent(m3uUrl.value))).text();
 else if(m3uText.value) texto=m3uText.value;
 else if(m3uFile.files[0]) texto=await m3uFile.files[0].text();
 else{hideLoader();alert("Informe uma lista");return;}

 let linhas=texto.split(/\r?\n/),last="";
 let total=0,proc=0;
 linhas.forEach(l=>{if(l.startsWith("http")&&!l.includes("/movie/")&&!l.includes("/series/"))total++;});

 for(let l of linhas){
  l=l.trim();
  if(l.startsWith("#EXTINF")) last=l;
  if(l.startsWith("http")){
   let nome=last.split(",").pop()||"Sem nome";
   let cat=(last.match(/group-title="([^"]+)"/)||[])[1]||"SEM_CATEGORIA";
   let tipo="canal";
   if(l.includes("/movie/")) tipo="filme";
   else if(l.includes("/series/")) tipo="serie";

   if(!categorias[tipo][cat]) categorias[tipo][cat]=[];
   categorias[tipo][cat].push({nome,url:l});

   if(tipo==="canal"){
    proc++;
    loaderCounts.innerText=proc+" canais";
    loaderPercent.innerText=Math.floor((proc/total)*100)+"%";
    await new Promise(r=>setTimeout(r,1));
   }
  }
 }
 render();
 hideLoader();
}

function toggleCard(card){
 const chk=card.querySelector(".checkbox");
 chk.checked=!chk.checked;
 atualizarSelecionados();
}

function render(){
 grid.innerHTML="";
 for(let tipo in categorias){
  for(let cat in categorias[tipo]){
   let q=categorias[tipo][cat].length;
   grid.innerHTML+=`
   <div class="category-card" data-tipo="${tipo}" onclick="toggleCard(this)">
    <input type="checkbox" class="checkbox" data-tipo="${tipo}" data-cat="${cat}" checked onclick="event.stopPropagation();atualizarSelecionados()">
    <div class="category-title">${cat}</div>
    <div class="category-count">${q} itens</div>
    <div class="card-buttons">
     <button class="btn-info" onclick="event.stopPropagation();ver('${tipo}','${cat}')">👁</button>
     <button class="btn-warning" onclick="event.stopPropagation();testar('${tipo}','${cat}')">🧪</button>
     <button class="btn-success" onclick="event.stopPropagation();baixar('${tipo}','${cat}')">⬇</button>
    </div>
   </div>`;
  }
 }
 aplicarFiltro();
 atualizarSelecionados();
}

function gerar(t,c){
 let m="#EXTM3U\n";
 categorias[t][c].forEach(x=>m+=`#EXTINF:-1 group-title="${c}",${x.nome}\n${x.url}\n`);
 return m;
}

function ver(t,c){window.open(URL.createObjectURL(new Blob([gerar(t,c)])));}
function baixar(t,c){let a=document.createElement("a");a.href=URL.createObjectURL(new Blob([gerar(t,c)]));a.download=c+".m3u";a.click();}
function testar(t,c){
 fetch("save_temp.php",{method:"POST",body:gerar(t,c)})
 .then(r=>r.text()).then(f=>window.open("tester.html?file="+f,"_blank"));
}

function filtrar(t,btn){
 filtroAtual=t;
 document.querySelectorAll(".top-menu button").forEach(b=>b.classList.remove("active"));
 btn.classList.add("active");
 aplicarFiltro();
}
function aplicarFiltro(){
 document.querySelectorAll(".category-card").forEach(c=>{
  c.style.display=(filtroAtual==="all"||c.dataset.tipo===filtroAtual)?"block":"none";
 });
}

function marcarTodos(){document.querySelectorAll(".checkbox").forEach(c=>c.checked=true);atualizarSelecionados();}
function desmarcarTodos(){document.querySelectorAll(".checkbox").forEach(c=>c.checked=false);atualizarSelecionados();}

async function baixarZip(){
 let zip=new JSZip(),root=zip.folder("LISTAS");
 for(let t in categorias){
  let p=root.folder(t.toUpperCase());
  for(let c in categorias[t]) p.file(c+".m3u",gerar(t,c));
 }
 let b=await zip.generateAsync({type:"blob"});
 let a=document.createElement("a");a.href=URL.createObjectURL(b);a.download="listas.zip";a.click();
}

async function baixarSelecionados(){
 let zip=new JSZip();
 let nome="LISTA";
 if(m3uUrl.value){try{nome=new URL(m3uUrl.value).hostname.replace(/\./g,"_");}catch(e){}}
 let root=zip.folder(nome);
 let pastas={canal:root.folder("CANAIS"),filme:root.folder("FILMES"),serie:root.folder("SERIES"),sem:root.folder("SEM_CATEGORIA")};
 document.querySelectorAll(".checkbox:checked").forEach(c=>pastas[c.dataset.tipo].file(c.dataset.cat+".m3u",gerar(c.dataset.tipo,c.dataset.cat)));
 let b=await zip.generateAsync({type:"blob"});
 let a=document.createElement("a");a.href=URL.createObjectURL(b);a.download=nome+"_selecionados.zip";a.click();
}

function limpar(){
 m3uUrl.value="";m3uText.value="";m3uFile.value="";
 grid.innerHTML="";categorias={canal:{},filme:{},serie:{},sem:{}};
 validadeM3U.innerText="—";
 atualizarSelecionados();
}
</script>

</body>
</html>
