<?php
header("Content-Type: application/json");

if(!isset($_GET["url"])) {
  echo json_encode(["error"=>"URL ausente"]);
  exit;
}

$url = $_GET["url"];
$host = parse_url($url, PHP_URL_HOST);
if(!$host){
  echo json_encode(["error"=>"URL inválida"]);
  exit;
}

/* =======================
   1️⃣ CHAMA SEU CHECKER
======================= */
$checker = "https://sync.adautosuper.net/M3U/Check/api/iptv_checker.php";

$post = http_build_query(["playlist_url"=>$url]);

$ch = curl_init($checker);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);
$response = curl_exec($ch);
curl_close($ch);

$check = json_decode($response,true);

if(!$check || !isset($check["status"])){
  echo json_encode([
    "status"=>"checker_off",
    "server"=>$host
  ]);
  exit;
}

/* =======================
   2️⃣ CALCULA VALIDADE
======================= */

$expireRaw = $check["details"]["Expira em"] ?? null;
$now = time();
$expire = $expireRaw ? strtotime($expireRaw) : 0;
$diff = $expire - $now;

$days = floor($diff / 86400);
$hours = floor(($diff % 86400) / 3600);

/* =======================
   3️⃣ GEOIP
======================= */
$ip = gethostbyname($host);
$geo = json_decode(file_get_contents("http://ip-api.com/json/".$ip), true);

/* =======================
   4️⃣ STATUS FINAL
======================= */
$status = $check["status"];

if($status=="active" && $diff<=0) $status="expired";

if($status=="active" && $days<=1) $risk="yellow";
elseif($status=="active") $risk="green";
else $risk="red";

echo json_encode([
  "server"=>$host,
  "ip"=>$ip,
  "status"=>$status,
  "risk"=>$risk,
  "expire_raw"=>$expireRaw,
  "days"=>$days,
  "hours"=>$hours,
  "max_connections"=>$check["details"]["Max Connections"] ?? 0,
  "used_connections"=>$check["details"]["Active Connections"] ?? 0,
  "country"=>$geo["country"] ?? "",
  "countryCode"=>$geo["countryCode"] ?? "",
  "isp"=>$geo["isp"] ?? ""
]);
