<?php
header("Content-Type: application/json");

$url = $_POST['playlist_url'] ?? '';

if(!$url || !filter_var($url, FILTER_VALIDATE_URL)){
    echo json_encode([
        "ok" => false,
        "status" => "INVALID_URL",
        "blocked" => true
    ]);
    exit;
}

/* Chama seu checker interno */
$ch = curl_init("http://localhost/M3U/Check/api/iptv_checker.php");
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => [
        "playlist_url" => $url
    ],
    CURLOPT_TIMEOUT => 15
]);

$res = curl_exec($ch);
curl_close($ch);

if(!$res){
    echo json_encode([
        "ok" => false,
        "status" => "CHECKER_OFFLINE",
        "blocked" => true
    ]);
    exit;
}

$data = json_decode($res, true);

if(!$data || !isset($data["status"])){
    echo json_encode([
        "ok" => false,
        "status" => "INVALID_RESPONSE",
        "blocked" => true
    ]);
    exit;
}

/* Se não estiver ativa → bloqueia */
if($data["status"] !== "ACTIVE"){
    echo json_encode([
        "ok" => false,
        "status" => $data["status"],
        "blocked" => true
    ]);
    exit;
}

/* Data de expiração */
if(!isset($data["details"]["Expira em"])){
    echo json_encode([
        "ok" => false,
        "status" => "NO_EXPIRY",
        "blocked" => true
    ]);
    exit;
}

$expire = strtotime(str_replace("/", "-", $data["details"]["Expira em"]));
$now = time();
$diff = $expire - $now;

if($diff <= 0){
    echo json_encode([
        "ok" => false,
        "status" => "EXPIRED",
        "blocked" => true
    ]);
    exit;
}

$hours = floor($diff / 3600);
$days  = floor($hours / 24);

/* Monta retorno limpo */
echo json_encode([
    "ok" => true,
    "status" => "ACTIVE",
    "expires_at" => date("Y-m-d H:i:s", $expire),
    "hours" => $hours,
    "days" => $days,
    "warning" => ($hours < 24 || $days <= 3),
    "blocked" => false
]);
